//by Deathfly
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.combat.entities.Ship;


public class NeutPACBeamEffect implements BeamEffectPlugin {

    public NeutPACBeamEffect() {
    }

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        ShipAPI playerShip = engine.getPlayerShip();
        if (beam.getSource() == playerShip) {
            engine.maintainStatusForPlayerShip("NeutHERPEffect", "graphics/icons/tactical/venting_flux2.png", "Main Weapon Firing", "Vents Blocked", true);
        }
        if (engine.isPaused()) {
            return;
        }
        ((Ship) beam.getSource()).blockCommandForOneFrame(com.fs.starfarer.combat.entities.Ship.oo.valueOf("VENT_FLUX"));
    }
}
